<?php
/**
 * Setup & Debug Page
 * Use this to test your database connection
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>SourceHub - Setup & Debug</h1>";
echo "<hr>";

// Test 1: PHP Version
echo "<h3>✓ PHP Version</h3>";
echo "Running PHP " . phpversion() . "<br><br>";

// Test 2: MySQLi Extension
echo "<h3>MySQLi Extension</h3>";
if (extension_loaded('mysqli')) {
    echo "✓ MySQLi is installed<br><br>";
} else {
    echo "✗ MySQLi is NOT installed. Contact your hosting provider!<br><br>";
}

// Test 3: Database Connection
echo "<h3>Database Connection Test</h3>";

$db_host = 'localhost';
$db_user = 'root';  // CHANGE THIS
$db_pass = '';      // CHANGE THIS
$db_name = 'sourcehub';

echo "Attempting to connect to: $db_host<br>";
echo "Database user: $db_user<br>";
echo "Database name: $db_name<br><br>";

$conn = new mysqli($db_host, $db_user, $db_pass);

if ($conn->connect_error) {
    echo "<span style='color:red;'>✗ Connection Failed: " . $conn->connect_error . "</span><br>";
    echo "<p><strong>Solutions:</strong></p>";
    echo "<ul>";
    echo "<li>Check your database username and password (found in cPanel > MySQL Databases)</li>";
    echo "<li>Make sure the user has proper privileges</li>";
    echo "<li>Contact your hosting provider if MySQL is not enabled</li>";
    echo "</ul>";
} else {
    echo "<span style='color:green;'>✓ Connected Successfully</span><br>";
    
    // Create database
    if (!$conn->query("CREATE DATABASE IF NOT EXISTS " . $db_name)) {
        echo "<span style='color:red;'>✗ Error creating database: " . $conn->error . "</span><br>";
    } else {
        echo "<span style='color:green;'>✓ Database created/verified</span><br>";
    }
    
    $conn->select_db($db_name);
    
    // Test tables
    echo "<br><h4>Database Tables:</h4>";
    $tables = $conn->query("SHOW TABLES");
    if ($tables) {
        $count = $tables->num_rows;
        echo "Found " . $count . " tables<br>";
        while ($row = $tables->fetch_array()) {
            echo "- " . $row[0] . "<br>";
        }
    }
    
    echo "<br><span style='color:green;'>✓ All tests passed!</span>";
    echo "<br><br><a href='index.php'><strong>Click here to go to home page</strong></a>";
}

?>
<style>
    body {
        font-family: Arial, sans-serif;
        max-width: 600px;
        margin: 50px auto;
        padding: 20px;
        background: #f5f5f5;
    }
    h1 {
        color: #667eea;
    }
    h3 {
        margin-top: 20px;
    }
    ul {
        background: white;
        padding: 15px 30px;
        border-radius: 5px;
    }
</style>
